import sys
towns, roads = map(int, input().split(" "))
class Town:
    def __init__(self, children):
        self.children = children
        self.traversed = False
    def __repr__(self):
        return f"(Town -> {', '.join(map(lambda x: str(x + 1), self.children))})"

townlist = [Town([]) for _ in range(towns)]
for i in range(roads):
    start, finish = map(int, input().split(" "))
    townlist[start - 1].children.append(finish - 1)

def traverse(idx, prevlist=[]):
    if idx != 0:
        townlist[idx].traversed = True
    #print(f"Town {idx + 1} traversed")
    if idx == 0 and prevlist != []:
        print("YES")
        print(' '.join(list(map(lambda x: str(x + 1), prevlist)) + ["1"]))
        sys.exit()
    for i in townlist[idx].children:
        if not townlist[i].traversed:
            #print(f"Going to traverse town {i + 1} from town {idx + 1}")
            traverse(i, prevlist = prevlist + [idx])
traverse(0)
print("NO")
